

IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME='LINX_IO_PROD') 
BEGIN
/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 20220614 
'Job.................:  
'Nome................: LINX_IO_PROD
'Projeto............:  Commerce 
'Tabelas.............: 
'Dt Criao..........: 
'Dt Ult Alteraco....: 14/06/2022
'Alterado por........: Marcos Barros
'Criado por..........:    
'=======================================================================================
FARMAGOI-24164
*/
CREATE TABLE LINX_IO_PROD(
  CD_EMP int NOT NULL,
  CD_PROD int NOT NULL,
  DS_PROD VARCHAR(150) NOT NULL,
  CD_CLASS int,
  CD_DPTO int,
  CD_CATEG int,
  CD_SUB_CATEG int,
  CD_MC int,
  DT_GARANTIA date,
  TEMPO_SEPARACAO int,
  ALTURA money,
  LARGURA money,
  COMPRIMENTO money,
  PESO money,
  BLOQUEADO int NOT NULL,
  DT_CAD datetime,
  DT_ULT_ATU datetime,
  NM_USU varchar(50),
  CONSTRAINT [PK_LINX_IO_PROD] PRIMARY KEY CLUSTERED(CD_EMP ASC, CD_PROD ASC) 
);

ALTER TABLE LINX_IO_PROD ADD CONSTRAINT FK_LINX_IO_PROD_LINX_IO_CLASS FOREIGN KEY(CD_CLASS) REFERENCES LINX_IO_CLASS(CD_CLASS);

ALTER TABLE LINX_IO_PROD ADD CONSTRAINT FK_LINX_IO_PROD_LINX_IO_DPTO FOREIGN KEY(CD_DPTO) REFERENCES LINX_IO_DPTO(CD_DPTO);

ALTER TABLE LINX_IO_PROD ADD CONSTRAINT FK_LINX_IO_PROD_LINX_IO_CATEG FOREIGN KEY(CD_CATEG) REFERENCES LINX_IO_CATEG(CD_CATEG);

ALTER TABLE LINX_IO_PROD ADD CONSTRAINT FK_LINX_IO_PROD_LINX_IO_SUB_CATEG FOREIGN KEY(CD_SUB_CATEG) REFERENCES LINX_IO_SUB_CATEG(CD_SUB_CATEG);

ALTER TABLE LINX_IO_PROD ADD CONSTRAINT FK_LINX_IO_PROD_LINX_IO_MARCA FOREIGN KEY(CD_MC) REFERENCES LINX_IO_MARCA(CD_MC);
END
